//---------------------------------------------------------------------------
// File: svr_experience.cs
//
// This file contains the server-side experience system, which is used to
// update the experience values for saving purposes and to update the
// client experience blocks for rendering.
//
// Author: Michael Felice
//---------------------------------------------------------------------------


function CreateExperienceBlocks()
{
   // BUILDINGS
   new SLExperience(XPBuyWoodhut)
   {
      name = "Wood Hut";
      desc = "Wood huts allow Citizens to harvest Wood from nearby trees.";

      image = "~/client/ui/icons/woodhut";
      
      expCost = 15;
      goldCost = 20;
      
      reqDesc0 = "Complete Food Resource Task.";
      tab = 0;
      object = "WoodhutButton";
   };
   XPBuyWoodhut.Initialize();
   
   new SLExperience(XPBuyGoldmine)
   {
      name = "Gold Mine";
      desc = "Gold Mines will mine Gold when placed on Gold Veins.";

      image = "~/client/ui/icons/goldmine";
      
      expCost = 15;
      woodCost = 20;
      reqDesc0 = "Complete Wood Resource Task."; 
      tab = 0;
      object = "GoldmineButton";
   };
   XPBuyGoldmine.Initialize();
   
   new SLExperience(XPBuyHotel)
   {
      name = "Hotel";
      desc = "Hotels provide 5 new Citizens a comfortable place to live.";
      
      image = "~/client/ui/icons/hotel";
      
      expCost = 20;
      goldCost = 120;
      
      reqDesc0 = "Unlock the Lumber Mill.";
      
      tab = 0;
      object = "Hotelbutton";
      
      hideName = false;
      hideDesc = false;
      hideImage = false;
      hideExp = false;
      hideGold = false;
      hideWood = false;
      hideReq0 = false;
   };
   XPBuyHotel.Initialize();
      
   new SLExperience(XPBuyWindmill)
   {
      name = "Windmill";
      desc = "Windmills will boost Farm production up to 25%.";

      image = "~/client/ui/icons/windmill";
      
      expCost = 20;
      goldCost = 50;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "WindmillButton";
   };
   XPBuyWindmill.Initialize();
   
   new SLExperience(XPBuyLumbermill)
   {
      name = "Lumber Mill";
      desc = "Lumber Mills boost Wood Hut production up to 25%.";

      image = "~/client/ui/icons/lumbermill";
      
      expCost = 20;
      woodCost = 100;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "LumbermillButton";
   };
   XPBuyLumbermill.Initialize();
   
   new SLExperience(XPBuyTradingPost)
   {
      name = "Trading Post";
      desc = "Trading Posts allow you to buy and sell resources.";

      image = "~/client/ui/icons/tradingpost";
      
      expCost = 25;
      goldCost = 50;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "TradingpostButton";
   };
   XPBuyTradingPost.Initialize();
   
   new SLExperience(XPBuyWatchtower)
   {
      name = "Watchtower";
      desc = "Bandits will think twice about entering a town guarded by Watchtowers.";

      image = "~/client/ui/icons/watchtower";
      
      expCost = 20;
      woodCost = 50;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "WatchtowerButton";
   };
   XPBuyWatchtower.Initialize();
   
   new SLExperience(XPBuyBlacksmith)
   {
      name = "Blacksmith";
      desc = "Blacksmiths' boost Gold production and allow for the various equipment upgrades.";

      image = "~/client/ui/icons/blacksmith";
      
      expCost = 40;
      goldCost = 200;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "BlacksmithButton";
   };
   XPBuyBlacksmith.Initialize();
   
   new SLExperience(XPBuyBank)
   {
      name = "Bank";
      desc = "Banks allow you to tax Citizens at a Town Hall.";

      image = "~/client/ui/icons/bank";
      
      expCost = 40;
      goldCost = 200;
      
      reqDesc0 = "Unlock the Blacksmith.";
      
      tab = 0;
      object = "BankButton";
   };
   XPBuyBank.Initialize();
   
   new SLExperience(XPBuySheriffsOffice)
   {
      name = "Sheriff's Office";
      desc = "Hire a Sheriff and Deputies at the Sheriff's Office.";

      image = "~/client/ui/icons/SheriffsOffice";
      
      expCost = 15;
      woodCost = 80;
      
      reqDesc0 = "Complete the Tutorial.";
      reqDesc1 = "Build a town of 15 buildings.";
      
      hideReq1 = true;
      
      tab = 0;
      object = "SheriffsOfficeButton";
   };
   XPBuySheriffsOffice.Initialize();
   
   new SLExperience(XPBuyTownhall)
   {
      name = "Town Hall";
      desc = "Employ a Mayor at your Town Hall and throw your town a festival or tax them 'till it hurts.";

      image = "~/client/ui/icons/Townhall";
      
      expCost = 80;
      goldCost = 200;
      
      reqDesc0 = "Unlock the Lumbermill.";
      
      tab = 0;
      object = "TownhallButton";
   };
   XPBuyTownhall.Initialize();
   
   new SLExperience(XPBuySaloon)
   {
      name = "Saloon";
      desc = "Saloons are excellent places to hire up a few rough and tough Gunslingers.";

      image = "~/client/ui/icons/Saloon";
      
      expCost = 15;
      woodCost = 50;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "SaloonButton";
   };
   XPBuySaloon.Initialize();
   
   new SLExperience(XPBuyGeneral)
   {
      name = "General Store";
      desc = "General Stores allow you to buy tools and supplies.";

      image = "~/client/ui/icons/Generalstore";
      
      expCost = 20;
      woodCost = 50;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "GeneralButton";
   };
   XPBuyGeneral.Initialize();
   
   new SLExperience(XPBuyGranary)
   {
      name = "Granary";
      desc = "Granaries increase Food storage.";

      image = "~/client/ui/icons/Granary";
      
      expCost = 20;
      woodCost = 50;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "GranaryButton";
   };
   XPBuyGranary.Initialize();
   
   new SLExperience(XPBuyRanch)
   {
      name = "Ranch";
      desc = "Ranches allow you to raise Chickens, Pigs or Cattle.";

      image = "~/client/ui/icons/ranch";
      
      expCost = 25;
      woodCost = 80;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "RanchButton";
   };
   XPBuyRanch.Initialize();
   
   new SLExperience(XPBuyWatertower)
   {
      name = "Watertower";
      desc = "Watertowers increase Water storage.";

      image = "~/client/ui/icons/watertower";
      
      expCost = 10;
      woodCost = 30;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "WatertowerButton";
   };
   XPBuyWatertower.Initialize();
   
   new SLExperience(XPBuySmokehouse)
   {
      name = "Smokehouse";
      desc = "Smokehouses increase Food production for Ranches.";

      image = "~/client/ui/icons/Smokehouse";
      
      expCost = 20;
      woodCost = 50;
      
      reqDesc0 = "Unlock the Ranch.";
      
      tab = 0;
      object = "SmokehouseButton";
   };
   XPBuySmokehouse.Initialize();
   
   new SLExperience(XPBuyWelcome)
   {
      name = "Welcome Sign";
      desc = "Welcome your new Citizens with a finely crafted Welcome Sign.";

      image = "~/client/ui/icons/Welcomesign";
      
      expCost = 10;
      woodCost = 40;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 0;
      object = "WelcomesignButton";
   };
   XPBuyWelcome.Initialize();
   

// **************  Tools and UPGRADES **************

	 new SLExperience(XPBuyCorn)
   {
      name = "Corn";
      desc = "Purchase this item to grow Corn on your Farm.";

      image = "~/client/ui/icons/corn";
      
      expCost = 15;
      woodCost = 50;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 1;
      object = "ProduceCornCmdData";
   };
   XPBuyCorn.Initialize();
   
   new SLExperience(XPBuyPumpkins)
   {
      name = "Pumpkins";
      desc = "Purchase this item to grow Pumpkins on your Farm.";

      image = "~/client/ui/icons/pumpkin";

      expCost = 20;
      goldCost = 50;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 1;
      object = "ProducePumpCmdData";
   };
   XPBuyPumpkins.Initialize();
   
   new SLExperience(XPBuyPigs)
   {
      name = "Pigs";
      desc = "Purchase this item to raise Pigs on your Ranches.";

      image = "~/client/ui/icons/pig";
      
      expCost = 20;
      goldCost = 50;
      
      reqDesc0 = "Unlock the Ranch.";
      
      tab = 1;
      object = "ProducePigCmdData";
   };
   XPBuyPigs.Initialize();
   
   new SLExperience(XPBuyCows)
   {
      name = "Cattle";
      desc = "Purchase this item to raise Cattle on your Ranches.";

      image = "~/client/ui/icons/cattle";
      
      expCost = 30;
      goldCost = 50;
      
      reqDesc0 = "Unlock the Ranch.";
      
      tab = 1;
      object = "ProduceCowCmdData";
   };
   XPBuyCows.Initialize();
 
   new SLExperience(XPBuyGun)
   {
      name = "Guns";
      desc = "Purchase this item to increase the damage that your combat units deal.";

      image = "~/client/ui/icons/gunupgrade";
      
      expCost = 25;
      goldCost = 250;
      
      reqDesc0 = "Unlock the Blacksmith.";
      
      tab = 1;
      object = "GunUpgradeCmdData";
      /*
      upgrade = $CSUP_GUN;
      value = "5 95";
      */
   };
   XPBuyGun.Initialize();
   
   new SLExperience(XPBuyAxe)
   {
      name = "Axes";
      desc = "Purchase this item to increase the productivity of your Wood Huts.";

      image = "~/client/ui/icons/axeupgrade";
      
      expCost = 25;
      goldCost = 250;
      
      reqDesc0 = "Unlock the Blacksmith.";
      
      tab = 1;
      object = "AxeUpgradeCmdData";
      /*
      upgrade = $CSUP_AXE;
      value = 5;
      */
   };
   XPBuyAxe.Initialize();
   
   new SLExperience(XPBuyPick)
   {
      name = "Picks";
      desc = "Purchase this item to increase the productivity of your Gold Mines.";

      image = "~/client/ui/icons/pickaxeupgrade";
      
      expCost = 25;
      woodCost = 250;
      
      reqDesc0 = "Unlock the Blacksmith.";
      
      tab = 1;
      object = "PickUpgradeCmdData";
      /*
      upgrade = $CSUP_PICK;
      value = 5;
      */
   };
   XPBuyPick.Initialize();
   
   new SLExperience(XPBuyBuildingFortification)
   {
      name = "Fortification";
      desc = "Purchase this item to increase the strength of your buildings.";

      image = "~/client/ui/icons/strongerbuilding";
      
      expCost = 20;
      woodCost = 300;
      
      reqDesc0 = "Unlock the Lumber Mill";
      
      tab = 1;
      object = "BldgHpUpgradeCmdData";
      /*
      upgrade = $CSUP_BLDG;
      value = 50;
      */
   };
   XPBuyBuildingFortification.Initialize();
   
   new SLExperience(XPBuyTrack)
   {
      name = "Track Upgrade";
      desc = "Purchase this item to upgrade the wagon road to railroad tracks.";

      image = "~/client/ui/icons/train";

      expCost = 80;
      goldCost = 1000;
      
      reqDesc0 = "Unlock the Blacksmith";
      
      tab = 1;
      object = "TrackUpgradeCmdData";
      /*
      upgrade = $CSUP_TRACK;
      value = 50;
      */
   };
   XPBuyTrack.Initialize();

   // TOOLS
   new SLExperience(XPBuyDynamite)
   {
      name = "Dynamite";
      desc = "Purchase this item to buy and place Dynamite.";

      image = "~/client/ui/icons/tnt";
      
      expCost = 15;
      goldCost = 75;
      
      reqDesc0 = "Unlock the General Store";
      
      tab = 1;
      object = "PurchaseDynamiteCmdData";
   };
   XPBuyDynamite.Initialize();
   
   new SLExperience(XPBuyHealing)
   {
      name = "Healing";
      desc = "Purchase this item to heal combat units.";

      image = "~/client/ui/icons/healthkit";

      expCost = 15;
      goldCost = 50;
      
      reqDesc0 = "Unlock the General Store.";
      
      tab = 1;
      object = "PurchaseHealCmdData";
   };
   XPBuyHealing.Initialize();
   
   // BEAUTIFICATION
   
   new SLExperience(XPBuyBarberShop)
   {
      name = "Barber Shop";
      desc = "Purchase this item to build Barber Shops.";

      image = "~/client/ui/icons/barbershop";
      
      expCost = 20;
      goldCost = 100;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 2;
      object = "BarbershopButton";
   };
   XPBuyBarberShop.Initialize();
   
   new SLExperience(XPBuyOuthouse)
   {
      name = "Outhouse";
      desc = "Purchase this item to build Outhouses.";

      image = "~/client/ui/icons/outhouse";
      
      expCost = 10;
      woodCost = 50;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 2;
      object = "OuthouseButton";
   };
   XPBuyOuthouse.Initialize();
   
   new SLExperience(XPBuyGazebo)
   {
      name = "Gazebo";
      desc = "Purchase this item to build Gazebos.";

      image = "~/client/ui/icons/gazebo";
      
      expCost = 15;
      woodCost = 80;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 2;
      object = "GazeboButton";
   };
   XPBuyGazebo.Initialize();
   
   new SLExperience(XPBuyFountain)
   {
      name = "Fountain";
      desc = "Purchase this item to build Fountains.";

      image = "~/client/ui/icons/fountain";
      
      expCost = 20;
      goldCost = 50;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 2;
      object = "FountainButton";
   };
   XPBuyFountain.Initialize();
   
   new SLExperience(XPBuyStatue)
   {
      name = "Statue";
      desc = "Purchase this item to build Statues.";

      image = "~/client/ui/icons/statue";
      
      expCost = 15;
      goldCost = 80;
      
      reqDesc0 = "Unlock the Town Hall.";
      
      tab = 2;
      object = "StatueButton";
   };
   XPBuyStatue.Initialize();

   new SLExperience(XPBuyTownbell)
   {
      name = "Town Bell";
      desc = "Purchase this item to build Town Bells.";

      image = "~/client/ui/icons/townbell";
      
      expCost = 10;
      woodCost = 50;
      
      reqDesc0 = "Unlock the Town Hall.";
      
      tab = 2;
      object = "TownbellButton";
   };
   XPBuyTownbell.Initialize();
   
   new SLExperience(XPBuyChurch)
   {
      name = "Church";
      desc = "Purchase this item to build Churches and Cemeteries.";

      image = "~/client/ui/icons/Church";
      
      expCost = 20;
      woodCost = 100;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 2;
      object = "ChurchButton";
   };
   XPBuyChurch.Initialize();
   
   new SLExperience(XPBuyFlowerpot)
   {
      name = "Flower Pot";
      desc = "Purchase this item to build Flower Pots.";

      image = "~/client/ui/icons/Flowerpot";
      
      expCost = 10;
      goldCost = 15;
      
      reqDesc0 = "Complete the Tutorial.";
      
      tab = 2;
      object = "FlowerpotButton";
   };
   XPBuyFlowerpot.Initialize();
   
   ClearExperience();
}

function SLExperience::Initialize(%experience)
{
   if (MissionGroup.isMember(%experience))
   {
      MissionGroup.remove(%experience);
   }
   if (MissionCleanup.isMember(%experience))
   {
      MissionCleanup.remove(%experience);
   }
}


// this is the experience manager object
$ExperienceManager = 0;
$ResourceStack = 0;

function serverCmdDestroyResources(%client)
{
   DestroyResources();
}

function DestroyResources()
{
   if (isObject($ResourceStack) == false)
   {
      return;
   }
   GameResourceStack.destroy();
   GameResourceStack.delete();
   $ResourceStack = 0;
}

function CreateResources(%client)
{
   // reallocate the game resources before the experience manager is created
   // destroy the game resources at this point (if they previously existed)
   if (isObject($ResourceStack) == true)
   {
      return;
   }

   $ResourceStack = new SLResourceStack(GameResourceStack)
   {
      dataBlock = GameResourceData;
      
      addHousingNode = "0 30";
      addHousingNode = "50 15";
      addHousingNode = "100 5";
      minHousingHappiness = 0;
   };
   MissionCleanup.remove($ResourceStack);
   
   if (isObject(GameResourceStack) == false)
   {
      return;
   }
   
   GameResourceStack.initialize();

   // no objects have been placed at this point
   $ObjectToPlace = 0;
}

function DestroyExperience()
{
   // this handles removing any experience in the experience manager
   // before an existing experience manager is removed
   if (isObject($ExperienceManager) == true)
   {
      for (%tab = 0; %tab < 4; %tab++)
      {
         %count = $ExperienceManager.getCount(%tab);
         for (%index = 0; %index < %count; %index++)
         {
            %exp = $ExperienceManager.getExperience(%tab, %index);
            if (isObject(%exp))
            {
               %exp.delete();
            }
         }
      }
      
      $ExperienceManager.delete();
      $ExperienceManager = 0;
   }
}

function CreateExperience()
{
   DestroyExperience();
   
   // create a new experience manager (all experience created after
   // the experience manager is created will automatically be added
   // to the manager)
   $ExperienceManager = new SLExperienceManager(ExperienceManager) {};
   if (MissionGroup.isMember(ExperienceManager))
   {
      MissionGroup.remove(ExperienceManager);
   }
   if (MissionCleanup.isMember(ExperienceManager))
   {
      MissionCleanup.remove(ExperienceManager);
   }
   
   CreateExperienceBlocks();

   // this function tells the experience manager to send all of the
   // experience blocks that have been created to the client (for
   // rendering and buying purposes)
   $ExperienceManager.update();
}

// this function is used to update each of the experience blocks
// in the experience manager
function UpdateExperience()
{
   for (%tab = 0; %tab < 4; %tab++)
   {
      for (%index = 0; %index < ExperienceManager.getCount(%tab); %index++)
      {
         %exp = ExperienceManager.getExperience(%tab, %index);
         if (isObject(%exp) == true)
         {
            %exp.update(GameResourceStack.getResource());
         }
      }
   }
}

// thie function is used to update the server-side experience
function serverCmdUpdateExperience(%client)
{
   UpdateExperience();
   commandToClient(%client, 'ShowExperience');
}

function ActivateBuildingExperience(%building)
{
   %button = %building @ "Button";
   
   ActivateButtonExperience(%button);
}

function ActivateButtonExperience(%button)
{
   if (isObject(%button) == false)
   {
      return;
   }
   
   %tab = getWord(%button.xpCheck, 0);
   %index = getWord(%button.xpCheck, 1);
   
   // get the experience block we are loading from
   %exp = ExperienceManager.getExperience(%tab, %index);
   
   // if we are at the end of the page
   if (isObject(%exp) == false)
   {
      return;
   }
   
   // if the experience block has already been sold, it cannot be bought
   if (%exp.sold == true)
   {
      return;
   }

   // set the experience block to sold, update the resources based on
   // how much it costs to research the experience block
   %exp.setSold(true);   
   
   // send a message for the task system and anyone else that needs to know
   if (isObject(MsgSender)) 
   {
      MsgSender.sendMsg($MSG_XPBUY, $MRT_LOCAL, %exp.name);
   }
   
   // call a function to update the upgrade
   %client = ClientGroup.getObject(0);
   if (%exp.value !$= "")
   {
      csPurchaseCmdUpgrade(%client, %exp.upgrade, %exp.value);
   }
   // update the object for the upgrade
   if (%exp.object !$= "")
   {
      commandToClient(%client, 'XPBuyObject', %exp.object);
   }

   // update the experience block after the resource modifications
   // have been made
   UpdateExperience();
}

function ActivateAllExperience()
{
   echo("begin: activating all experience");
   
   // get the initial experience block we are loading from
   %exp = ExperienceManager.getExperience(0, 0);
   
   %tab = 0;
   %index = 0;
   %client = ClientGroup.getObject(0);
   while (isObject(%exp) == true)
   {
      while (isObject(%exp) == true)
      {
         // for all experience checks to be checked off
         for (%reqIndex = 0; %reqIndex < $MaxExperienceRequirements; %reqIndex++)
         {
            if (%exp.getReqCheck(%reqIndex) == false &&
               %exp.getReqDescription(%reqIndex) !$= "")
            {
               %exp.setReqCheck(%reqIndex, true);
            }
         }

         // set the experience block to sold, update the resources based on
         // how much it costs to research the experience block
         %exp.setSold(true);
         
         // call a function to update the upgrade
         if (%exp.value !$= "")
         {
            csPurchaseCmdUpgrade(%client, %exp.upgrade, %exp.value);
         }
         // update the object for the upgrade
         if (%exp.object !$= "")
         {
            commandToClient(%client, 'XPBuyObject', %exp.object);
         }
         
         %index++;
         
         // get the experience block we are loading from
         %exp = ExperienceManager.getExperience(%tab, %index);
      }
      
      %tab++;
      %index = 0;
      
      // get the experience block we are loading from
      %exp = ExperienceManager.getExperience(%tab, %index);
   }

   // update the experience block after the resource modifications
   // have been made
   UpdateExperience();
   
   echo("end: activating all experience");
}

// this function is called when the client has indicated that an
// experience block is being bought
function serverCmdBuyExperience(%client, %tab, %index)
{
   // get the experience block we are loading from
   %exp = ExperienceManager.getExperience(%tab, %index);
   
   // if we are at the end of the page
   if (isObject(%exp) == false)
   {
      serverCmdUpdateExperience(%client);
      return;
   }

   %buy = true;
   
   %gameResource = GameResourceStack.getResource();
   
   // ensure that the resources and requirements indicate that the
   // experience can be bought
   if (%gameResource.getExperience().getCount() < %exp.expCost) %buy = false;
   if (%gameResource.getGold().getCount() < %exp.goldCost) %buy = false;
   if (%gameResource.getWood().getCount() < %exp.woodCost) %buy = false;
   
   for (%reqIndex = 0; %reqIndex < $MaxExperienceRequirements; %reqIndex++)
   {
      if (%exp.getReqCheck(%reqIndex) == false &&
         %exp.getReqDescription(%reqIndex) !$= "")
      {
         %buy = false;
      }
   }
   
   // if the experience block has already been sold, it cannot be bought
   if (%exp.sold == true) %buy = false;
   
   // if the experience block cannot be bought, something is odd between
   // the server and the client, so update the client objects
   if (%buy == false)
   {
      serverCmdUpdateExperience(%client);
      return;
   }

   // set the experience block to sold, update the resources based on
   // how much it costs to research the experience block
   %exp.setSold(true);   
   %gameResource.getExperience().decreaseCount(%exp.expCost);
   %gameResource.getGold().decreaseCount(%exp.goldCost);
   %gameResource.getWood().decreaseCount(%exp.woodCost);
   
   // send a message for the task system and anyone else that needs to know
   if (isObject(MsgSender)) 
   {
      MsgSender.sendMsg($MSG_XPBUY, $MRT_LOCAL, %exp.name);
   }
   
   // call a function to update the upgrade
   if (%exp.value !$= "")
   {
      csPurchaseCmdUpgrade(%client, %exp.upgrade, %exp.value);
   }
   // update the object for the upgrade
   if (%exp.object !$= "")
   {
      commandToClient(%client, 'XPBuyObject', %exp.object);
   }

   // update the experience block after the resource modifications
   // have been made
   serverCmdUpdateExperience(%client);
}

// this function should be called every time the game is started
// (the experience is created)
function ClearExperience()
{
   %count = ClientGroup.getCount();
   for (%index = 0; %index < %count; %index++)
   {
      %client = ClientGroup.getObject(%index);
      commandToClient(%client, 'ClearExperience');
   }
}

// when xpcheck is changed on the client, the xpcheck flag needs
// to be set on the server, so this is done through here (for
// saving pusposes)
function serverCmdSaveXPCheck(%client, %tab, %index, %xpCheck)
{
   %block = ExperienceManager.getExperience(%tab, %index);
   %block.xpCheck = %xpCheck;
}

// this function is called from the server to set the xpcheck
function SLExperience::LoadXPCheck(%block, %tab, %index)
{
   %client = ClientGroup.getObject(0);
   commandToClient(%client, 'LoadXPCheck', %block.object, %tab, %index, %block.xpCheck);
}
